// geodesic forms 

#macro geo_divide (x1,y1,z1,x2,y2,z2,x3,y3,z3,re,membrane,framework,rr)
#local re=re-1;
#if (re<0)
 #if (framework>0)
  cylinder {<x1,y1,z1>,<x2,y2,z2>,rr}
  cylinder {<x2,y2,z2>,<x3,y3,z3>,rr}
  cylinder {<x3,y3,z3>,<x1,y1,z1>,rr}
  // nodes
  union {
   sphere { <x1,y1,z1>,rr*1.4 }
   sphere { <x2,y2,z2>,rr*1.4 }
   sphere { <x3,y3,z3>,rr*1.4 }
  }
 #end // if framework
 #if (membrane>0) 
  triangle {<x1,y1,z1>,<x2,y2,z2>,<x3,y3,z3>}
 #end // if membrane
 // recursion ends here
#else
 #local x11=x1+x2; #local y11=y1+y2; #local z11=z1+z2;
 #local spr=1/sqrt((x11*x11)+(y11*y11)+(z11*z11));
 #local x11=x11*spr; #local y11=y11*spr; #local z11=z11*spr;
 //
 #local x21=x2+x3; #local y21=y2+y3; #local z21=z2+z3;
 #local spr=1/sqrt((x21*x21)+(y21*y21)+(z21*z21));
 #local x21=x21*spr; #local y21=y21*spr; #local z21=z21*spr;
 //
 #local x31=x3+x1; #local y31=y3+y1; #local z31=z3+z1;
 #local spr=1/sqrt((x31*x31)+(y31*y31)+(z31*z31));
 #local x31=x31*spr; #local y31=y31*spr; #local z31=z31*spr;
 //  next recursion level
 geo_divide (x11,y11,z11,x31,y31,z31,x1,y1,z1,re+0,membrane,framework,rr+0) // top
 geo_divide (x2,y2,z2,x21,y21,z21,x11,y11,z11,re+0,membrane,framework,rr+0) // left
 geo_divide (x21,y21,z21,x3,y3,z3,x31,y31,z31,re+0,membrane,framework,rr+0) // right
 geo_divide (x21,y21,z21,x31,y31,z31,x11,y11,z11,re+0,membrane,framework,rr+0) //centre
#end // if
#end // macro


#macro geo_icosahedron(re,membrane,framework,rr)
//union {
//sphere { 0,0.1 }

//#local rr=0.01; // strut radius
//#local re=1; // division stages 1=4 2=16 3=64 per icos triangle
//#local membrane=1; // show membrane
//#local framework=1; // show framework

#local aa=(pi/2)-atan(2); // key constant
#local pp=cos(aa);
#local yy=sin(aa);
//
#local bb=0;      #declare x01=cos(bb)*pp; #declare z01=sin(bb)*pp;
#local bb=pi*0.4; #declare x02=cos(bb)*pp; #declare z02=sin(bb)*pp;
#local bb=pi*0.8; #declare x03=cos(bb)*pp; #declare z03=sin(bb)*pp;
#local bb=pi*1.2; #declare x04=cos(bb)*pp; #declare z04=sin(bb)*pp;
#local bb=pi*1.6; #declare x05=cos(bb)*pp; #declare z05=sin(bb)*pp;
//
#local bb=pi*0.2; #declare x11=cos(bb)*pp; #declare z11=sin(bb)*pp;
#local bb=pi*0.6; #declare x12=cos(bb)*pp; #declare z12=sin(bb)*pp;
#local bb=pi*1.0; #declare x13=cos(bb)*pp; #declare z13=sin(bb)*pp;
#local bb=pi*1.4; #declare x14=cos(bb)*pp; #declare z14=sin(bb)*pp;
#local bb=pi*1.8; #declare x15=cos(bb)*pp; #declare z15=sin(bb)*pp;
//
geo_divide(00,1,00,x01,yy,z01,x02,yy,z02,re+0,membrane,framework,rr)
geo_divide(00,1,00,x02,yy,z02,x03,yy,z03,re+0,membrane,framework,rr)
geo_divide(00,1,00,x03,yy,z03,x04,yy,z04,re+0,membrane,framework,rr)
geo_divide(00,1,00,x04,yy,z04,x05,yy,z05,re+0,membrane,framework,rr)
geo_divide(00,1,00,x05,yy,z05,x01,yy,z01,re+0,membrane,framework,rr)
//
geo_divide(00,-1,00,x11,-yy,z11,x12,-yy,z12,re+0,membrane,framework,rr)
geo_divide(00,-1,00,x12,-yy,z12,x13,-yy,z13,re+0,membrane,framework,rr)
geo_divide(00,-1,00,x13,-yy,z13,x14,-yy,z14,re+0,membrane,framework,rr)
geo_divide(00,-1,00,x14,-yy,z14,x15,-yy,z15,re+0,membrane,framework,rr)
geo_divide(00,-1,00,x15,-yy,z15,x11,-yy,z11,re+0,membrane,framework,rr)
//
geo_divide(x01,yy,z01,x11,-yy,z11,x02,yy,z02,re+0,membrane,framework,rr)
geo_divide(x02,yy,z02,x12,-yy,z12,x03,yy,z03,re+0,membrane,framework,rr)
geo_divide(x03,yy,z03,x13,-yy,z13,x04,yy,z04,re+0,membrane,framework,rr)
geo_divide(x04,yy,z04,x14,-yy,z14,x05,yy,z05,re+0,membrane,framework,rr)
geo_divide(x05,yy,z05,x15,-yy,z15,x01,yy,z01,re+0,membrane,framework,rr)
//
geo_divide(x11,-yy,z11,x02,yy,z02,x12,-yy,z12,re+0,membrane,framework,rr)
geo_divide(x12,-yy,z12,x03,yy,z03,x13,-yy,z13,re+0,membrane,framework,rr)
geo_divide(x13,-yy,z13,x04,yy,z04,x14,-yy,z14,re+0,membrane,framework,rr)
geo_divide(x14,-yy,z14,x05,yy,z05,x15,-yy,z15,re+0,membrane,framework,rr)
geo_divide(x15,-yy,z15,x01,yy,z01,x11,-yy,z11,re+0,membrane,framework,rr)
scale 6
// } // end macro
#end // macro

#macro geo_octahedron(re,membrane,framework,rr)
//union {
//sphere { 0,0.1 }
#declare rr=0.01; // strut radius
//#declare re=4;    // division stages 1=4 2=16 3=64 per icos triangle

#declare aa=0;
#declare pp=cos(aa);
#declare yy=sin(aa);
//
#declare bb=0;      #declare x01=cos(bb)*pp; #declare z01=sin(bb)*pp;
#declare bb=pi*0.5; #declare x02=cos(bb)*pp; #declare z02=sin(bb)*pp;
#declare bb=pi*1.0; #declare x03=cos(bb)*pp; #declare z03=sin(bb)*pp;
#declare bb=pi*1.5; #declare x04=cos(bb)*pp; #declare z04=sin(bb)*pp;
//
geo_divide(00, 1,00,x01,yy,z01,x02,yy,z02,re+0,membrane,framework,rr)
geo_divide(00, 1,00,x02,yy,z02,x03,yy,z03,re+0,membrane,framework,rr)
geo_divide(00, 1,00,x03,yy,z03,x04,yy,z04,re+0,membrane,framework,rr)
geo_divide(00, 1,00,x04,yy,z04,x01,yy,z01,re+0,membrane,framework,rr)
//
geo_divide(00,-1,00,x01,yy,z01,x02,yy,z02,re+0,membrane,framework,rr)
geo_divide(00,-1,00,x02,yy,z02,x03,yy,z03,re+0,membrane,framework,rr)
geo_divide(00,-1,00,x03,yy,z03,x04,yy,z04,re+0,membrane,framework,rr)
geo_divide(00,-1,00,x04,yy,z04,x01,yy,z01,re+0,membrane,framework,rr)
//
scale 6
//} // union
#end // macro
 
 
// #include "geodesic forms.inc"
#declare rr=0.005; // strut radius
#declare re=3; // division stages 1=4 2=16 3=64 per icos triangle
#declare membrane=0; // show membrane
#declare framework=1; // show framework
#declare geo_test=
union {
 geo_octahedron(re,membrane,framework,rr)
 pigment { crackle 
  color_map{
  [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
  [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
  }
  // color rgb <0,1,1>
  scale 0.5
 } // pigm
 finish { phong 0.2 ambient 0.3 }
 rotate 45*z
 translate <0,1,ds>
} // union


